<?php
class DashboardController {
    public function __construct() {
        auth_guard();
    }
    
    public function index() {
        $db = get_db_connection();
        $today = date('Y-m-d');
        
        // Today's stats
        $stmt = $db->prepare("SELECT COUNT(*) as count, SUM(amount) as sum FROM sms_transactions WHERE DATE(received_at) = ?");
        $stmt->bind_param('s', $today);
        $stmt->execute();
        $today_stats = $stmt->get_result()->fetch_assoc();

        // Total stats
        $stmt = $db->prepare("SELECT COUNT(*) as count, SUM(amount) as sum FROM sms_transactions");
        $stmt->execute();
        $total_stats = $stmt->get_result()->fetch_assoc();

        $data = [
            'title' => 'Dashboard',
            'today_transactions' => $today_stats['count'] ?? 0,
            'today_volume' => $today_stats['sum'] ?? 0,
            'total_transactions' => $total_stats['count'] ?? 0,
            'total_volume' => $total_stats['sum'] ?? 0,
        ];
        view('dashboard_view', $data);
    }
}
